//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: When the timer starts and the counter value is the same as T00REG and T01REG, the TC01 interrupt occurs.
//				  At this point, P90 output level is inverted. 
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
void main()
{
    WDCDR.byte = 0x4e;			//clear WDT   
    P9CR.bit.b0	=	1;
	__asm("DI");
	POFFCR0.byte	=	0x10; 	//enable TC00 and TC01 
	EIRH.bit.b5	=	1; 			// enable TC01 interrupt 
	__asm("EI");
	T01MOD.byte	=	0xC8;		//<DBE0>=1,<TCK0>=001,<EIN0>=0,<TCM0>=0 8-bit timer mode
	T001CR.bit.b2	=	1;		// switch to 16-bit mode
	T00REG.byte	=	0xA1;		// set timer value
	T01REG.byte	=	0x7;		// set timer value
	T001CR.bit.b1	=	1;		// start 16-bit timer



	while(1)
	{
		WDCDR.byte = 0x4e;			//clear WDT   
	}          
    
}